/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.render.CCRenderState;
import codechicken.nei.GuiNEIButton;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IGuiContainerOverlay;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IGuiClientSide;
import codechicken.nei.guihook.IGuiHandleMouseWheel;
import codechicken.nei.recipe.ContainerRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiRecipe
extends GuiContainer
implements IGuiContainerOverlay,
IGuiClientSide,
IGuiHandleMouseWheel,
IContainerTooltipHandler {
    public ArrayList<? extends IRecipeHandler> currenthandlers = new ArrayList();
    public int page;
    public int recipetype;
    public ContainerRecipe slotcontainer = (ContainerRecipe)this.inventorySlots;
    public GuiContainer firstGui;
    public GuiContainer prevGui;
    public GuiButton nextpage;
    public GuiButton prevpage;
    public GuiButton overlay1;
    public GuiButton overlay2;

    protected GuiRecipe(GuiContainer prevgui) {
        super((Container)new ContainerRecipe());
        this.prevGui = prevgui;
        this.firstGui = prevgui;
        if (prevgui instanceof IGuiContainerOverlay) {
            this.firstGui = ((IGuiContainerOverlay)prevgui).getFirstScreen();
        }
    }

    public void initGui() {
        super.initGui();
        this.currenthandlers = this.getCurrentRecipeHandlers();
        GuiNEIButton nexttype = new GuiNEIButton(0, this.width / 2 - 70, (this.height - this.ySize) / 2 + 3, 13, 12, "<");
        GuiNEIButton prevtype = new GuiNEIButton(1, this.width / 2 + 57, (this.height - this.ySize) / 2 + 3, 13, 12, ">");
        this.nextpage = new GuiNEIButton(2, this.width / 2 - 70, (this.height + this.ySize) / 2 - 18, 13, 12, "<");
        this.prevpage = new GuiNEIButton(3, this.width / 2 + 57, (this.height + this.ySize) / 2 - 18, 13, 12, ">");
        this.overlay1 = new GuiNEIButton(4, this.width / 2 + 65, (this.height - this.ySize) / 2 + 63, 13, 12, "?");
        this.overlay2 = new GuiNEIButton(5, this.width / 2 + 65, (this.height - this.ySize) / 2 + 128, 13, 12, "?");
        this.buttonList.add(nexttype);
        this.buttonList.add(prevtype);
        this.buttonList.add(this.nextpage);
        this.buttonList.add(this.prevpage);
        this.buttonList.add(this.overlay1);
        this.buttonList.add(this.overlay2);
        if (this.currenthandlers.size() == 1) {
            nexttype.visible = false;
            prevtype.visible = false;
        }
        this.refreshPage();
    }

    public void keyTyped(char c, int i) {
        if (i == 1) {
            this.mc.displayGuiScreen((GuiScreen)this.firstGui);
            return;
        }
        if (GuiContainerManager.getManager(this).lastKeyTyped(i, c)) {
            return;
        }
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int recipe = this.page * recipehandler.recipiesPerPage(); recipe < recipehandler.numRecipes() && recipe < (this.page + 1) * recipehandler.recipiesPerPage(); ++recipe) {
            if (!recipehandler.keyTyped(this, c, i, recipe)) continue;
            return;
        }
        if (i == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.displayGuiScreen((GuiScreen)this.firstGui);
        } else if (i == NEIClientConfig.getKeyBinding("gui.back")) {
            this.mc.displayGuiScreen((GuiScreen)this.prevGui);
        }
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int recipe = this.page * recipehandler.recipiesPerPage(); recipe < recipehandler.numRecipes() && recipe < (this.page + 1) * recipehandler.recipiesPerPage(); ++recipe) {
            if (!recipehandler.mouseClicked(this, par3, recipe)) continue;
            return;
        }
        super.mouseClicked(par1, par2, par3);
    }

    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        switch (guibutton.id) {
            case 0: {
                this.prevType();
                break;
            }
            case 1: {
                this.nextType();
                break;
            }
            case 2: {
                this.prevPage();
                break;
            }
            case 3: {
                this.nextPage();
                break;
            }
            case 4: {
                this.overlayRecipe(this.page * this.currenthandlers.get(this.recipetype).recipiesPerPage());
                break;
            }
            case 5: {
                this.overlayRecipe(this.page * this.currenthandlers.get(this.recipetype).recipiesPerPage() + 1);
            }
        }
    }

    public void updateScreen() {
        super.updateScreen();
        this.currenthandlers.get(this.recipetype).onUpdate();
        this.refreshPage();
    }

    @Override
    public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            currenttip = recipehandler.handleTooltip(this, currenttip, i);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack stack, int mousex, int mousey, List<String> currenttip) {
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            currenttip = recipehandler.handleItemTooltip(this, stack, currenttip, i);
        }
        return currenttip;
    }

    @Override
    public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
        return currenttip;
    }

    private void nextPage() {
        ++this.page;
        if (this.page > (this.currenthandlers.get(this.recipetype).numRecipes() - 1) / this.currenthandlers.get(this.recipetype).recipiesPerPage()) {
            this.page = 0;
        }
    }

    private void prevPage() {
        --this.page;
        if (this.page < 0) {
            this.page = (this.currenthandlers.get(this.recipetype).numRecipes() - 1) / this.currenthandlers.get(this.recipetype).recipiesPerPage();
        }
    }

    private void nextType() {
        ++this.recipetype;
        if (this.recipetype >= this.currenthandlers.size()) {
            this.recipetype = 0;
        }
        this.page = 0;
    }

    private void prevType() {
        --this.recipetype;
        if (this.recipetype < 0) {
            this.recipetype = this.currenthandlers.size() - 1;
        }
        this.page = 0;
    }

    private void overlayRecipe(int recipe) {
        IRecipeOverlayRenderer renderer = this.currenthandlers.get(this.recipetype).getOverlayRenderer(this.firstGui, recipe);
        IOverlayHandler handler = this.currenthandlers.get(this.recipetype).getOverlayHandler(this.firstGui, recipe);
        boolean shift = NEIClientUtils.shiftKey();
        if (handler != null && (renderer == null || shift)) {
            this.mc.displayGuiScreen((GuiScreen)this.firstGui);
            handler.overlayRecipe(this.firstGui, this.currenthandlers.get(this.recipetype), recipe, shift);
        } else if (renderer != null) {
            this.mc.displayGuiScreen((GuiScreen)this.firstGui);
            LayoutManager.overlayRenderer = renderer;
        }
    }

    public void refreshPage() {
        boolean multiplepages;
        this.refreshSlots();
        IRecipeHandler handler = this.currenthandlers.get(this.recipetype);
        this.nextpage.visible = multiplepages = handler.numRecipes() > handler.recipiesPerPage();
        this.prevpage.visible = multiplepages;
        if (this.firstGui != null) {
            this.overlay1.yPosition = (this.height - this.ySize) / 2 + (handler.recipiesPerPage() == 2 ? 63 : 128);
            this.overlay1.visible = handler.hasOverlay(this.firstGui, this.firstGui.inventorySlots, this.page * handler.recipiesPerPage());
            this.overlay2.visible = handler.recipiesPerPage() == 2 && this.page * handler.recipiesPerPage() + 1 < handler.numRecipes() && handler.hasOverlay(this.firstGui, this.firstGui.inventorySlots, this.page * handler.recipiesPerPage() + 1);
        } else {
            this.overlay2.visible = false;
            this.overlay1.visible = false;
        }
    }

    private void refreshSlots() {
        this.slotcontainer.inventorySlots.clear();
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            Point p = this.getRecipePosition(i);
            List<PositionedStack> stacks = recipehandler.getIngredientStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            stacks = recipehandler.getOtherStacks(i);
            for (PositionedStack stack : stacks) {
                this.slotcontainer.addSlot(stack, p.x, p.y);
            }
            PositionedStack result = recipehandler.getResultStack(i);
            if (result == null) continue;
            this.slotcontainer.addSlot(result, p.x, p.y);
        }
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        GuiContainerManager.enable2DRender();
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        String s = recipehandler.getRecipeName();
        this.fontRendererObj.drawString(s, (this.xSize - this.fontRendererObj.getStringWidth(s)) / 2, 5, 0x404040);
        s = NEIClientUtils.translate("recipe.page", this.page + 1, (this.currenthandlers.get(this.recipetype).numRecipes() - 1) / recipehandler.recipiesPerPage() + 1);
        this.fontRendererObj.drawString(s, (this.xSize - this.fontRendererObj.getStringWidth(s)) / 2, this.ySize - 16, 0x404040);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)5.0f, (float)16.0f, (float)0.0f);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            recipehandler.drawForeground(i);
            GL11.glTranslatef((float)0.0f, (float)65.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CCRenderState.changeTexture((String)"nei:textures/gui/recipebg.png");
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(j + 5), (float)(k + 16), (float)0.0f);
        IRecipeHandler recipehandler = this.currenthandlers.get(this.recipetype);
        for (int i = this.page * recipehandler.recipiesPerPage(); i < recipehandler.numRecipes() && i < (this.page + 1) * recipehandler.recipiesPerPage(); ++i) {
            recipehandler.drawBackground(i);
            GL11.glTranslatef((float)0.0f, (float)65.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    @Override
    public GuiContainer getFirstScreen() {
        return this.firstGui;
    }

    public boolean isMouseOver(PositionedStack stack, int recipe) {
        Slot stackSlot = this.slotcontainer.getSlotWithStack(stack, this.getRecipePosition((int)recipe).x, this.getRecipePosition((int)recipe).y);
        Point mousepos = GuiDraw.getMousePosition();
        Slot mouseoverSlot = this.getSlotAtPosition(mousepos.x, mousepos.y);
        return stackSlot == mouseoverSlot;
    }

    public Point getRecipePosition(int recipe) {
        return new Point(5, 16 + recipe % this.currenthandlers.get(this.recipetype).recipiesPerPage() * 65);
    }

    @Override
    public void mouseScrolled(int i) {
        if (new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize).contains(GuiDraw.getMousePosition())) {
            if (i > 0) {
                this.prevPage();
            } else {
                this.nextPage();
            }
        }
    }

    public abstract ArrayList<? extends IRecipeHandler> getCurrentRecipeHandlers();
}

